/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.base.VWString;
import java.util.Hashtable;

public final class VWActionType {
    public static final int ACTION_TYPE_ASSIGN = 0;
    public static final int ACTION_TYPE_BEGIN_TIMER = 1;
    public static final int ACTION_TYPE_CALL = 5;
    public static final int ACTION_TYPE_CREATE = 6;
    public static final int ACTION_TYPE_DELAY = 7;
    public static final int ACTION_TYPE_END_ALL_TIMERS = 8;
    public static final int ACTION_TYPE_END_TIMER = 9;
    public static final int ACTION_TYPE_RESUME_TIMER = 13;
    public static final int ACTION_TYPE_RETURN = 14;
    public static final int ACTION_TYPE_SUSPEND_TIMER = 16;
    public static final int ACTION_TYPE_TERMINATE = 17;
    public static final int ACTION_TYPE_TERMINATE_BRANCH = 17;
    public static final int ACTION_TYPE_WAIT_FOR_EVENT = 19;
    public static final int ACTION_TYPE_EXECUTE = 23;
    public static final int ACTION_TYPE_NOOP = 24;
    public static final int ACTION_TYPE_BEGIN_CHECKPOINT = 27;
    public static final int ACTION_TYPE_END_CHECKPOINT = 28;
    public static final int ACTION_TYPE_ROLLBACK_CHECKPOINT = 29;
    public static final int ACTION_TYPE_DB_EXECUTE = 37;
    public static final int ACTION_TYPE_LOG = 38;
    public static final int ACTION_TYPE_INVOKE = 39;
    public static final int ACTION_TYPE_RECEIVE = 40;
    public static final int ACTION_TYPE_REPLY = 41;
    public static final int ACTION_TYPE_TERMINATE_PROCESS = 42;
    public static final int VARIABLE_PARAMS = 999;
    private static Hashtable LocalizedStrings = new Hashtable();

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 00:43:06  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.27  $";
    }

    public static boolean isValid(int actionType) {
        switch (actionType) {
            case 0: 
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                return true;
            }
        }
        return false;
    }

    public static int numberOfParameters(int actionType) throws VWException {
        int retVal = -1;
        if (!VWActionType.isValid(actionType)) {
            throw new VWException("vw.api.VWActionTypeBadInteger", "Integer form of the action type is invalid: {0}", String.valueOf(actionType));
        }
        switch (actionType) {
            case 8: 
            case 17: 
            case 24: 
            case 27: 
            case 28: 
            case 42: {
                retVal = 0;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 16: {
                retVal = 1;
                break;
            }
            case 38: {
                retVal = 2;
                break;
            }
            case 0: {
                retVal = 999;
                break;
            }
            case 1: {
                retVal = 4;
                break;
            }
            case 6: 
            case 19: 
            case 23: 
            case 29: 
            case 37: 
            case 39: 
            case 40: 
            case 41: {
                retVal = 999;
            }
        }
        return retVal;
    }

    public static String getLocalizedString(int actionType) throws VWException {
        if (!VWActionType.isValid(actionType)) {
            throw new VWException("vw.api.VWActionTypeBadInteger", "Integer form of the action type is invalid: {0}", String.valueOf(actionType));
        }
        return LocalizedStrings.get(new Integer(actionType)).toString();
    }

    protected static String typeToString(int actionType) throws VWException {
        switch (actionType) {
            case 0: {
                return "assign";
            }
            case 1: {
                return "begin_timer";
            }
            case 5: {
                return "call";
            }
            case 6: {
                return "create";
            }
            case 7: {
                return "delay";
            }
            case 8: {
                return "end_all_timers";
            }
            case 9: {
                return "end_timer";
            }
            case 13: {
                return "resume_timer";
            }
            case 14: {
                return "return";
            }
            case 16: {
                return "suspend_timer";
            }
            case 17: {
                return "terminateBranch";
            }
            case 42: {
                return "terminateProcess";
            }
            case 19: {
                return "wait_for_event";
            }
            case 23: {
                return "execute";
            }
            case 24: {
                return "no_op";
            }
            case 27: {
                return "begin_checkpoint";
            }
            case 28: {
                return "end_checkpoint";
            }
            case 29: {
                return "rollback_checkpoint";
            }
            case 37: {
                return "db_execute";
            }
            case 38: {
                return "log";
            }
            case 39: {
                return "invoke";
            }
            case 40: {
                return "receive";
            }
            case 41: {
                return "reply";
            }
        }
        throw new VWException("vw.api.VWActionTypeBadInteger", "Integer form of the action type is invalid: {0}", String.valueOf(actionType));
    }

    protected static int stringToType(String actionType) throws VWException {
        if (actionType.equals("assign")) {
            return 0;
        }
        if (actionType.equals("begin_timer")) {
            return 1;
        }
        if (actionType.equals("call")) {
            return 5;
        }
        if (actionType.equals("create")) {
            return 6;
        }
        if (actionType.equals("delay")) {
            return 7;
        }
        if (actionType.equals("end_all_timers")) {
            return 8;
        }
        if (actionType.equals("end_timer")) {
            return 9;
        }
        if (actionType.equals("resume_timer")) {
            return 13;
        }
        if (actionType.equals("return")) {
            return 14;
        }
        if (actionType.equals("suspend_timer")) {
            return 16;
        }
        if (actionType.equals("terminate") || actionType.equals("terminateBranch")) {
            return 17;
        }
        if (actionType.equals("terminateProcess")) {
            return 42;
        }
        if (actionType.equals("wait_for_event")) {
            return 19;
        }
        if (actionType.equals("execute")) {
            return 23;
        }
        if (actionType.equals("no_op")) {
            return 24;
        }
        if (actionType.equals("begin_checkpoint")) {
            return 27;
        }
        if (actionType.equals("end_checkpoint")) {
            return 28;
        }
        if (actionType.equals("rollback_checkpoint")) {
            return 29;
        }
        if (actionType.equals("db_execute")) {
            return 37;
        }
        if (actionType.equals("log")) {
            return 38;
        }
        if (actionType.equals("invoke")) {
            return 39;
        }
        if (actionType.equals("receive")) {
            return 40;
        }
        if (actionType.equals("reply")) {
            return 41;
        }
        throw new VWException("vw.api.VWActionTypeBadInteger", "Integer form of the action type is invalid: {0}", String.valueOf(actionType));
    }

    static {
        LocalizedStrings.put(new Integer(0), new VWString("vw.api.VWActionTypeAssign", "Assign"));
        LocalizedStrings.put(new Integer(1), new VWString("vw.api.VWActionTypeBeginTimer", "BeginTimer"));
        LocalizedStrings.put(new Integer(5), new VWString("vw.api.VWActionTypeCall", "Call"));
        LocalizedStrings.put(new Integer(6), new VWString("vw.api.VWActionTypeCreate", "Create"));
        LocalizedStrings.put(new Integer(7), new VWString("vw.api.VWActionTypeDelay", "Delay"));
        LocalizedStrings.put(new Integer(8), new VWString("vw.api.VWActionTypeEndAllTimers", "EndAllTimers"));
        LocalizedStrings.put(new Integer(9), new VWString("vw.api.VWActionTypeEndTimer", "EndTimer"));
        LocalizedStrings.put(new Integer(13), new VWString("vw.api.VWActionTypeResumeTimer", "ResumeTimer"));
        LocalizedStrings.put(new Integer(14), new VWString("vw.api.VWActionTypeReturn", "Return"));
        LocalizedStrings.put(new Integer(16), new VWString("vw.api.VWActionTypeSuspendTimer", "SuspendTimer"));
        LocalizedStrings.put(new Integer(17), new VWString("vw.api.VWActionTypeTerminateBranch", "TerminateBranch"));
        LocalizedStrings.put(new Integer(19), new VWString("vw.api.VWActionTypeWaitForEvent", "WaitForCondition"));
        LocalizedStrings.put(new Integer(23), new VWString("vw.api.VWActionTypeExecute", "Execute"));
        LocalizedStrings.put(new Integer(24), new VWString("vw.api.VWActionTypeNoOp", "NoOp"));
        LocalizedStrings.put(new Integer(27), new VWString("vw.api.VWActionTypeBeginCheckpoint", "BeginCheckpoint"));
        LocalizedStrings.put(new Integer(28), new VWString("vw.api.VWActionTypeEndCheckpoint", "EndCheckpoint"));
        LocalizedStrings.put(new Integer(29), new VWString("vw.api.VWActionTypeRollbackCheckpoint", "RollbackCheckpoint"));
        LocalizedStrings.put(new Integer(37), new VWString("vw.api.VWActionTypeDbExecute", "DbExecute"));
        LocalizedStrings.put(new Integer(38), new VWString("vw.api.VWActionTypeLog", "Log"));
        LocalizedStrings.put(new Integer(39), new VWString("vw.api.VWActionTypeInvoke", "Invoke"));
        LocalizedStrings.put(new Integer(40), new VWString("vw.api.VWActionTypeReceive", "Receive"));
        LocalizedStrings.put(new Integer(41), new VWString("vw.api.VWActionTypeReply", "Reply"));
        LocalizedStrings.put(new Integer(42), new VWString("vw.api.VWActionTypeTerminateProcess", "TerminateProcess"));
    }
}

